// libraries
#include <WiFi.h>
#include <Servo.h>
#include <Adafruit_Sensor.h>
#include <DHT.h>

#define DHTTYPE DHT22 // defining the type of sensor we have
Servo myservo;  // create servo object to control a servo

static const int servoPin = 21; // GPIO the servo is attached to

// network credentials
const char* ssid     = "hotspotmobil";
const char* password = "123456789";

WiFiServer server(80); // Set web server port number to 80

String header; // Variable to store the HTTP request
String output23State = "off"; // Auxiliar variables to store the current output state
const int output23 = 23; // Assign output variables to GPIO pins
const int DHTPin = 18; // DHT Sensor
DHT dht(DHTPin, DHTTYPE); // Initialize DHT sensor.

// Temporary variables for Temperature/Humidity sensor
static char celsiusTemp[7];
static char fahrenheitTemp[7];
static char humidityTemp[7];

unsigned long currentTime = millis(); // Current time
unsigned long previousTime = 0; // Previous time
const long timeoutTime = 2000; // Define timeout time in milliseconds (example: 2000ms = 2s)

// Decode HTTP GET value
String valueString = String(5);
int pos1 = 0;
int pos2 = 0;

void setup() {
  Serial.begin(115200);
  dht.begin();

  myservo.attach(servoPin);  // attaches the servo on the servoPin to the servo object
  pinMode(output23, OUTPUT); // Initialize the output variable as output
  digitalWrite(output23, LOW); // Set outputs to LOW
  
    // Connect to Wi-Fi network with SSID and password
  Serial.print("Connecting to ");
  Serial.println(ssid);
  WiFi.begin(ssid, password);
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  // Print local IP address and start web server
  Serial.println("");
  Serial.println("WiFi connected.");
  Serial.println("IP address: ");
  Serial.println(WiFi.localIP());
  server.begin();
}

void loop(){
  WiFiClient client = server.available();   // Listen for incoming clients
    if (client) {                             // If a new client connects,
    currentTime = millis();
    previousTime = currentTime;
    Serial.println("New Client.");          // print a message out in the serial port
    String currentLine = "";                // make a String to hold incoming data from the client
    while (client.connected() && currentTime - previousTime <= timeoutTime) {  // loop while the client's connected
      currentTime = millis();
      if (client.available()) {             // if there's bytes to read from the client,
        char c = client.read();             // read a byte, then
        Serial.write(c);                    // print it out the serial monitor
        header += c;
        if (c == '\n') {                    // if the byte is a newline character
          // if the current line is blank, you got two newline characters in a row.
          // that's the end of the client HTTP request, so send a response:
            float h = dht.readHumidity();
            // Read temperature as Celsius (the default)
            float t = dht.readTemperature();
            // Read temperature as Fahrenheit (isFahrenheit = true)
            float f = dht.readTemperature(true);
      if (isnan(h) || isnan(t) || isnan(f)) {
              Serial.println("Failed to read from DHT sensor!");
              strcpy(celsiusTemp,"Failed");
              strcpy(fahrenheitTemp, "Failed");
              strcpy(humidityTemp, "Failed");         
            }
            else{
              // Computes temperature values in Celsius + Fahrenheit and Humidity
              float hic = dht.computeHeatIndex(t, h, false);       
              dtostrf(hic, 6, 2, celsiusTemp);             
              float hif = dht.computeHeatIndex(f, h);
              dtostrf(hif, 6, 2, fahrenheitTemp);         
              dtostrf(h, 6, 2, humidityTemp);
              // Not-Essential prints
              Serial.print("Humidity: ");
              Serial.print(h);
              Serial.print(" %\t Temperature: ");
              Serial.print(t);
              Serial.print(" *C ");
              Serial.print(f);
              Serial.print(" *F\t Heat index: ");
              Serial.print(hic);
              Serial.print(" *C ");
              Serial.print(hif);
              Serial.print(" *F");
              Serial.print("Humidity: ");
              Serial.print(h);
              Serial.print(" %\t Temperature: ");
              Serial.print(t);
              Serial.print(" *C ");
              Serial.print(f);
              Serial.print(" *F\t Heat index: ");
              Serial.print(hic);
              Serial.print(" *C ");
              Serial.print(hif);
              Serial.println(" *F");
            }

          if (currentLine.length() == 0) {
            // HTTP headers always start with a response code (e.g. HTTP/1.1 200 OK)
            // and a content-type so the client knows what's coming, then a blank line:
            client.println("HTTP/1.1 200 OK");
            client.println("Content-type:text/html");
            client.println("Connection: close");
            client.println();
      
                // turns the GPIOs on and off
            if (header.indexOf("GET /23/on") >= 0) {
              Serial.println("GPIO 23 on");
              output23State = "on";
              digitalWrite(output23, HIGH);
            } else if (header.indexOf("GET /23/off") >= 0) {
              Serial.println("GPIO 23 off");
              output23State = "off";
              digitalWrite(output23, LOW);

            }
            
            // Display the HTML web page
            client.println("<!DOCTYPE html><html>"); // HTML
            client.println("<head><meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">"); //HEAD
            client.println("<link rel=\"icon\" type=\"image/x-icon\" href=\"https://i.ibb.co/mqr2vM0/favicon-32x32.png\">"); // FAVICON
            client.println("<link rel=\"stylesheet\" href=\"https://use.fontawesome.com/releases/v5.7.2/css/all.css\" integrity=\"sha384-fnmOCqbTlWIlj8LyTjo7mOUStjsKC4pOpQbqyi7RrhN7udi9RwhKkMHpvLbHG9Sr\" crossorigin=\"anonymous\">"); // Thermometer and Humidity pictures are from here
            client.println("<title> InfaKIT Web </title> "); // TITLE OF WEBPAGE IN TAB

            // CSS to style the on/off buttons 
            client.println("<style>html { font-family: Helvetica; display: inline-block; margin: 0px auto; text-align: center; background-colour: #2F7A45}");
            client.println(".button { background-color: #2F7A45; border: none; color: white; padding: 16px 40px;");
            client.println("text-decoration: none; font-size: 30px; margin: 2px; cursor: pointer;}");
            client.println(".button2 {background-color: #0d0000;}</style></head>");
            
            // More CSS
            client.println("<style>body { text-align: center; font-family: \"Trebuchet MS\", Arial; margin-left:auto; margin-right:auto;}");
            client.println(".units { font-size: 1.2rem; }");
            client.println(".dht-labels {font-size: 2.0rem;}");
            client.println(".slider { width: 300px; }</style>");
            client.println("<script src=\"https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js\"></script>");
                     
            // Web Page
            client.println("</head><body>"); // BODY
            // client.print("<img src=\"https://i.ibb.co/mXLYPwv/test2.jpg\" width=100% height=300>"); // The BANNER version1 (Isep+Infa+EPS LOGO)
            client.print("<img src=\"https://i.ibb.co/ggLvfNL/Whats-App-Image-2022-06-19-at-5-47-48-PM.jpg\" width=100% height=300>"); // The BANNER version 2 (Isep+Infa+EPS LOGO)

            // This is the Servomotor Part
            client.println("<div class=\"food\" style=\"width: 350px; float:left; height:50px; margin-top:10px; margin-left: 150px;\">");
            client.println("<p>Position: <span id=\"servoPos\"></span></p>"); 
            client.println("<span style=\"font-size: 20px;float:right; color:#2F7A45\">Open</span><span style=\"font-size: 20px; color: #0d0000; float:left;\">Closed</span>");         
            client.println("<input type=\"range\" min=\"0\" max=\"180\" class=\"slider\" id=\"servoSlider\" onchange=\"servo(this.value)\" value=\""+valueString+"\"/>");
            client.println("<script>var slider = document.getElementById(\"servoSlider\");");
            client.println("var servoP = document.getElementById(\"servoPos\"); servoP.innerHTML = slider.value;");
            client.println("slider.oninput = function() { slider.value = this.value; servoP.innerHTML = this.value; }");
            client.println("$.ajaxSetup({timeout:1000}); function servo(pos) { ");
            client.println("$.get(\"/?value=\" + pos + \"&\"); {Connection: close};}</script>");
            client.println("</div>");
            
      
      
            // This is the FAN Part 
            client.println("<div class=\"fan\" style=\"width: 200px; align: center; float: left; height:50px; margin-top: 10px; margin-left: 300px;\">");
            client.println("<p>FAN - State " + output23State + "</p>");
            // If the output23State is off, it displays the ON button       
            if (output23State=="off") {
              client.println("<p><a href=\"/23/on\"><button class=\"button\">ON</button></a></p>");
            } else {
              client.println("<p><a href=\"/23/off\"><button class=\"button button2\">OFF</button></a></p>");
            } 
            client.println("</div>");   
               
            // This is the SENSOR Part
            client.println("<div class=\"sensor\" style=\"width: 270px; align: center; float: right; height:50px; margin-top: 10px; margin-right: 100px;\">");
            client.println("<p style= \"font-size: 4.0rem;\">");
            client.print("<i class=\"fas fa-thermometer-half\" style=\"color:#059e8a;\"></i>");
            client.print("<span class=\"dht-labels\"> Temperature</span>");
            client.print(celsiusTemp); client.println("<sup class=\"units\" style=\"font-size: 2.0rem\;\">&deg\;C </sup>");
            client.println("</p>");

            client.println("<p style= \"font-size: 4.0rem;\">");
            client.print("<i class=\"fas fa-tint\" style=\"color:#00add6;\"></i> ");
            client.println("<span class=\"dht-labels\">Humidity </span>");
            client.println(humidityTemp);
            client.println("%</h3><h3>");
            client.println("</p>");
            client.println("</div>");
        
            client.println("</body></html>"); 
            
            //GET /?value=180& HTTP/1.1
            if(header.indexOf("GET /?value=")>=0) {
              pos1 = header.indexOf('=');
              pos2 = header.indexOf('&');
              valueString = header.substring(pos1+1, pos2);
              
              //Rotate the servo
              myservo.write(valueString.toInt());
              Serial.println(valueString); 
            }         
            // The HTTP response ends with another blank line
            client.println();
            // Break out of the while loop
            break;
          } else { // if you got a newline, then clear currentLine
            currentLine = "";
          }
        } else if (c != '\r') {  // if you got anything else but a carriage return character,
          currentLine += c;      // add it to the end of the currentLine
        }
      }
    }
    // Clear the header variable
    header = "";
    // Close the connection
    client.stop();
    Serial.println("Client disconnected.");
    Serial.println("");
  }
}

      
